insheet using  "Annual unemployment rate by state (1976-2010).csv", clear
drop annual*
drop if st==""
for var jan* feb* mar* apr* may* jun* jul* aug* sep* oct* nov* dec*: destring X, ignore("(P)" " ") replace force
reshape long jan feb mar apr may jun jul aug sep oct nov dec, i(st) j(year)
drop seriesid
egen ur=rmean(jan-dec)
keep st year ur
la var ur "Unemployment rate (Annual average; sa)"
replace ur=ur/100
sort st year
save "Unemployment", replace
